﻿#!/system/bin/sh

#WIN_IP=`netstat -anp | grep 5555 |grep ESTABLISHED | awk '{print $4}' | awk -F: '{print $4}' | sort -u`
WIN_IP=`cat ./win_ip.txt|xargs echo -n`
LOG_PATH=map_log

get_ini_value()
{
    section="$1"
    key="$2"
    value=$(awk -F '=' '/'"$section"'/ {a=1} a==1&&$1=="'"$key"'" {gsub("\r", "", $2); print $2; a=0}' camera.ini)
    echo "$value" 
}

TEA_CAM_IP=$(get_ini_value "RECORDER" "TeacherIP")

TEA_RTSP=$(get_ini_value "RECORDER" "TeacherRtsp")

TEA_VISCA=$(get_ini_value "RECORDER" "TeacherVisca")

TEA_UDP=$(get_ini_value "RECORDER" "TeacherUdp")

TEA_TCP=$(get_ini_value "RECORDER" "TeacherTcp")

TEA_BACKUP=$(get_ini_value "RECORDER" "TeacherBackup")

STU_CAM_IP=$(get_ini_value "RECORDER" "StudentIP")

STU_RTSP=$(get_ini_value "RECORDER" "StudentRtsp")

STU_VISCA=$(get_ini_value "RECORDER" "StudentVisca")

STU_UDP=$(get_ini_value "RECORDER" "StudentUdp")

STU_TCP=$(get_ini_value "RECORDER" "StudentTcp")

STU_BACKUP=$(get_ini_value "RECORDER" "StudentBackup")

# 获取到的值
echo "teacher_cam_ip: ${TEA_CAM_IP}"
echo "teacher_rtsp: ${TEA_RTSP}"
echo "teacher_visca: ${TEA_VISCA}"
echo "teacher_udp: ${TEA_UDP}"
echo "teacher_tcp: ${TEA_TCP}"
echo "teacher_backup: ${TEA_BACKUP}"

echo "student_cam_ip: ${STU_CAM_IP}"
echo "student_rtsp: ${STU_RTSP}"
echo "student_visca: ${STU_VISCA}"
echo "student_udp: ${STU_UDP}"
echo "student_tcp: ${STU_TCP}"
echo "student_backup: ${STU_BACKUP}"
echo "WIN_IP: ${WIN_IP}"

killall socat-tea
killall socat-stu
chmod +x ./socat-tea
chmod +x ./socat-stu
if [ ! -d ./$LOG_PATH ];then
	mkdir ./$LOG_PATH
fi

sleep 1

echo "开始映射学生机"
#学生机端口映射
./socat-stu tcp4-listen:$STU_RTSP,reuseaddr,fork tcp4:$STU_CAM_IP:554 2>&1 > ./$LOG_PATH/stu-socat554.log &
./socat-stu tcp4-listen:$STU_BACKUP,reuseaddr,fork tcp4:$STU_CAM_IP:5555 2>&1 > ./$LOG_PATH/stu-socat15555.log &
./socat-stu udp4-recvfrom:$STU_VISCA,fork udp4-sendto:$STU_CAM_IP:1259 2>&1 > ./$LOG_PATH/stu-socat1259.log &
./socat-stu udp4-recvfrom:$STU_UDP,fork udp4-sendto:$STU_CAM_IP:6791 2>&1 > ./$LOG_PATH/stu-socat6791.log &
ret=`ping -c 1 -W 1 $STU_CAM_IP | grep "100% packet loss"`
if [ x"$ret" = x"" ];then
    ret=`./socat-stu -T 1 - TCP4:$STU_CAM_IP:6793 2>&1`
    if [ x"$ret" = x"" ];then
        ./socat-stu tcp4-listen:$STU_TCP,reuseaddr,fork tcp4:$STU_CAM_IP:6793 2>&1 > ./$LOG_PATH/stu-socat6793.log &
    fi
fi
echo "映射学生机完成"

echo "开始映射教师机"
#教师机端口映射
./socat-tea tcp4-listen:$TEA_RTSP,reuseaddr,fork tcp4:$TEA_CAM_IP:554 2>&1 > ./$LOG_PATH/tea-socat554.log &
./socat-tea tcp4-listen:$TEA_BACKUP,reuseaddr,fork tcp4:$TEA_CAM_IP:5555 2>&1 > ./$LOG_PATH/tea-socat5555.log &
./socat-tea udp4-recvfrom:$TEA_VISCA,fork udp4-sendto:$TEA_CAM_IP:1259 2>&1 > ./$LOG_PATH/tea-socat1259.log &
./socat-tea udp4-recvfrom:$TEA_UDP,fork udp4-sendto:$TEA_CAM_IP:6791 2>&1 > ./$LOG_PATH/tea-socat6791.log &
ret=`ping -c 1 -W 1 $TEA_CAM_IP | grep "100% packet loss"`
if [ x"$ret" = x"" ];then
    ret=`./socat-tea -T 1 - TCP4:$TEA_CAM_IP:6793 2>&1`
    if [ x"$ret" = x"" ];then
        ./socat-tea tcp4-listen:$TEA_TCP,reuseaddr,fork tcp4:$TEA_CAM_IP:6793 2>&1 > ./$LOG_PATH/tea-socat6793.log &
    fi
fi
#配置工具UDP端口映射
./socat-tea udp4-recvfrom:7791,fork udp4-sendto:$WIN_IP:7791 2>&1 > ./$LOG_PATH/socat7791.log &
echo "映射教师机完成"
exit
